--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNmatEditor ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCchanList = #()
  local LOCmapSize  = [175,120]
  local LOCmatName

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNupdateMatPanel FUNselectedChannel =
  (
    local LOCsceneMats = sceneMaterials
    DYNmatEditor.LOCmatName = substring DYNamite.dnExplorer.selectedNode.name 2 -1
    if LOCsceneMats[DYNmatEditor.LOCmatName] != undefined then
    (
      DYNmatEditor.GBDYNgroup05.text         = DYNmatEditor.LOCmatName
      DYNmatEditor.LOCchanList               = (DYNFUNgetMatChannelNames LOCsceneMats[DYNmatEditor.LOCmatName] true false DYNINImatIDlimit)
      DYNmatEditor.MLDYNchanList.items       = DYNmatEditor.LOCchanList
      DYNmatEditor.LBDYNheading.text         = LOCsceneMats[DYNmatEditor.LOCmatName].name
      DYNmatEditor.SPDYNvehBody.value        = rootNode.DYNrootNodeStore.vehRayAmount
      DYNmatEditor.CKDYNvehBody.checked      = rootNode.DYNrootNodeStore.vehRayTrace
      if rootNode.DYNrootNodeStore.vehRayTrace then DYNmatEditor.SPDYNvehBody.enabled = true else DYNmatEditor.SPDYNvehBody.enabled = false
      if LOCsceneMats[DYNmatEditor.LOCmatName].count > 0 then
      (
        DYNmatEditor.BMDYNdiffMap.bitmap     = DYNFUNrenderMatMap (DYNiniExplorerWidth - 21) DYNmatEditor.LOCmapSize.y LOCsceneMats[DYNmatEditor.LOCmatName] FUNselectedChannel
        DYNmatEditor.MLDYNchanList.selection = FUNselectedChannel
      )
      DYNmatEditor.SPMATmarkBlur.value       = rootNode.DYNrootNodeStore.markBlur
      DYNmatEditor.MLDYNchanList.enabled     = true

      if DYNmatEditor.LOCmatName == DYNmatNameRails or DYNmatEditor.LOCmatName == DYNmatNameSurfaces or DYNmatEditor.LOCmatName == DYNmatNameVehicles or DYNmatEditor.LOCmatName == DYNmatNameBuildings then
      (
        DYNmatEditor.BUDYNaddChannel.enabled = true
      )
      else
      (
        DYNmatEditor.BUDYNaddChannel.enabled = false
      )
    )
    else
    (
      DYNmatEditor.MLDYNchanList.enabled = false
      DYNmatEditor.BUDYNaddChannel.enabled = false
    )

    if DYNmatEditor.LOCmatName == DYNmatNameVehicles then
    (
      DYNmatEditor.GBDYNgroup01.visible = true
      DYNmatEditor.CKDYNvehBody.visible = true
      DYNmatEditor.LBDYNvehBody.visible = true
      DYNmatEditor.SPDYNvehBody.visible = true
    )

    if DYNmatEditor.LOCmatName == DYNmatNameMarkings then
    (
      DYNmatEditor.GBDYNgroup04.visible = true
      DYNmatEditor.LBMATmarkBlur.visible = true
      DYNmatEditor.SPMATmarkBlur.visible = true
    )

    DYNmatEditor.CKDYNvehBody.enabled        = if LOCsceneMats[DYNmatNameVehicles] == undefined then false else true
    DYNmatEditor.LBDYNvehBody.enabled        = DYNmatEditor.SPDYNvehBody.enabled     = if LOCsceneMats[DYNmatNameVehicles] == undefined then false else true
    DYNmatEditor.LBMATmarkBlur.enabled       = DYNmatEditor.SPMATmarkBlur.enabled    = if LOCsceneMats[DYNmatNameMarkings] == undefined then false else true
    DYNmatEditor.BUDYNresetMaterial.enabled  = if DYNmatEditor.LOCmatName == DYNmatNameSurfaces or DYNmatEditor.LOCmatName == DYNmatNameVehicles or DYNmatEditor.LOCmatName == DYNmatNameRails then true else false
  )

  fn DYNFUNresetMaterial FUNmatName =
  (
    if FUNmatName == DYNmatNameSurfaces or FUNmatName == DYNmatNameVehicles or FUNmatName == DYNmatNameRails then
    (
      if (queryBox (FUNmatName + "\n\n" + DYNuiResourcesErrorsWarnings[26]) title:DYNuiResourcesTitlebars[2]) then
      (
        undo off
        (
          if sceneMaterials[FUNmatName] != undefined then
          (
            if FUNmatName == DYNmatNameSurfaces then
            (
              local LOColdMat = sceneMaterials[FUNmatName]; LOColdMat.name = "DynamiteTempMat"
              local LOCnewMat = DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\")
              for i = 1 to objects.count do (if objects[i].material == LOColdMat then objects[i].material = LOCnewMat)
              if DYNmatEditor.open then DYNmatEditor.DYNFUNupdateMatPanel 1
            )
            if FUNmatName == DYNmatNameVehicles then
            (
              local LOColdMat = sceneMaterials[FUNmatName]; LOColdMat.name = "DynamiteTempMat"
              local LOCnewMat = DYNFUNmakeCivilViewVehicles (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")
              for i = 1 to objects.count do (if objects[i].material == LOColdMat then objects[i].material = LOCnewMat)
              if DYNmatEditor.open then DYNmatEditor.DYNFUNupdateMatPanel 1
            )
            if FUNmatName == DYNmatNameRails then
            (
              local LOColdMat = sceneMaterials[FUNmatName]; LOColdMat.name = "DynamiteTempMat"
              local LOCnewMat = DYNFUNmakeCivilViewRails (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\")
              for i = 1 to objects.count do (if objects[i].material == LOColdMat then objects[i].material = LOCnewMat)
              if DYNmatEditor.open then DYNmatEditor.DYNFUNupdateMatPanel 1
            )
          )
        )
        DYNFUNnodeCreatedCallback()
      )
    )
    else
    (
      messagebox (FUNmatName + "\n\n" + DYNuiResourcesErrorsWarnings[25]) title:DYNuiResourcesTitlebars[2] beep:false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label   LBDYNheading       align:#center
  label   LBDYNchanList      align:#left pos:[4,26]
  listBox MLDYNchanList      pos:[4,41]  width:(DYNiniExplorerWidth - 21) height:6
  label   LBDYNdiffMap       align:#left pos:[4,134]
  bitmap  BMDYNdiffMap       pos:[4,150] width:(DYNiniExplorerWidth - 21) height:LOCmapSize.y pos:[3,100]

  groupBox GBDYNgroup05      pos:[4,276] width:(DYNiniExplorerWidth - 21) height:97
  button BUDYNaddChannel     pos:[13,295] width:(DYNiniExplorerWidth - 39)
  button BUDYNresetMaterial  pos:[13,319] width:(DYNiniExplorerWidth - 39)
  button BUDYNMaterialEditor pos:[13,343] width:(DYNiniExplorerWidth - 39)

  groupBox GBDYNgroup01      pos:[4,377] width:(DYNiniExplorerWidth - 21) height:61 visible:false
  checkbox CKDYNvehBody      pos:[13,396] width:(DYNiniExplorerWidth - 33) visible:false
  label LBDYNvehBody         pos:[13,417] visible:false
  spinner  SPDYNvehBody      type:#integer range:[0,100,0] align:#right pos:[(DYNiniExplorerWidth - 96),416] fieldwidth:60 visible:false

  groupBox GBDYNgroup04      pos:[4,377] width:(DYNiniExplorerWidth - 21) height:40 visible:false
  label    LBMATmarkBlur     pos:[13,397] visible:false align:#left
  spinner  SPMATmarkBlur     fieldwidth:60 type:#float range:[0.01,100.0,0.0] scale:0.05 pos:[(DYNiniExplorerWidth - 96),396] visible:false

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNmatEditor open do
  (
    DYNmatEditor.title       = DYNuiRolloutNames[8]
    GBDYNgroup01.text        = DYNuiResourcesGroups[30]
    GBDYNgroup04.text        = DYNuiResourcesGroups[31]
    LBDYNchanList.text       = DYNuiResourcesLabels[96]
    LBDYNdiffMap.text        = DYNuiResourcesLabels[97]
    CKDYNvehBody.text        = DYNuiResourcesLabels[98]
    LBDYNvehBody.text        = DYNuiResourcesLabels[99]
    LBMATmarkBlur.text       = DYNuiResourcesLabels[101]
    BUDYNaddChannel.text     = DYNuiResourcesButtons[45]
    BUDYNresetMaterial.text  = DYNuiResourcesButtons[46]
    BUDYNMaterialEditor.text = DYNuiResourcesButtons[47]

    DYNmatEditor.DYNFUNupdateMatPanel 1
  )

  on DYNmatEditor close do
  (
  )

  on SPMATmarkBlur entered do
  (
    local LOCsceneMats = sceneMaterials
    rootNode.DYNrootNodeStore.markBlur = SPMATmarkBlur.value
    if LOCsceneMats[DYNmatNameMarkings] != undefined then
    (
      for i = 1 to LOCsceneMats[DYNmatNameMarkings].count do
      (
        if classOf LOCsceneMats[DYNmatNameMarkings][i] == StandardMaterial  then (try (LOCsceneMats[DYNmatNameMarkings][i].opacityMap.coords.blur = rootNode.DYNrootNodeStore.markBlur) catch ())
        if classOf LOCsceneMats[DYNmatNameMarkings][i] == Arch___Design__mi then (try (LOCsceneMats[DYNmatNameMarkings][i].cutOut_map.coords.blur = rootNode.DYNrootNodeStore.markBlur) catch ())
      )
    )
  )

  on SPDYNvehBody entered do
  (
    local LOCsceneMats = sceneMaterials
    rootNode.DYNrootNodeStore.vehRayAmount = SPDYNvehBody.value
    if LOCsceneMats[DYNmatNameVehicles] != undefined then
    (
      for i = 1 to 9 do
      (
        try (LOCsceneMats[DYNmatNameVehicles][i].reflectionMapAmount = rootNode.DYNrootNodeStore.vehRayAmount) catch ()
      )
    )
  )

  on BUDYNaddChannel pressed do
  (
    if LOCmatName == DYNmatNameSurfaces or LOCmatName == DYNmatNameVehicles or LOCmatName == DYNmatNameBuildings or LOCmatName == DYNmatNameRails then
    (
      local LOCsceneMats = sceneMaterials
      if LOCsceneMats[LOCmatName] != undefined then
      (
        --- Select bitmap, then if selected folder was not standard country kit folder for this map type, ask if user wants to copy image to correct folder
        local LOCfilePath
        if LOCmatName == DYNmatNameSurfaces  then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameSurfaceMaps + "\\")
        if LOCmatName == DYNmatNameVehicles  then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")
        if LOCmatName == DYNmatNameBuildings then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameBuildingMaps + "\\")
        if LOCmatName == DYNmatNameRails     then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\")
        local LOCnewMap = DYNFUNcopyFileToResourceKitPath (LOCfilePath + "*.gif") DYNuiResourcesTitlebars[13] DYNimageTypes 1

        --- Load selected bitmap file into selected material definition
        if LOCnewMap != undefined then
        (
          local LOCaddCnt = 0
          if LOCmatName == DYNmatNameRails then
          (
            local LOCaddCnt = DYNFUNaddRailMatChannel LOCsceneMats[LOCmatName] LOCnewMap false
          )
          else
          (
            if LOCmatName == DYNmatNameBuildings then
            (
              local LOCaddCnt = DYNFUNAddBuildingMatChannel LOCsceneMats[LOCmatName] LOCnewMap false
            )
            else
            (
              local LOCaddCnt = DYNFUNgeneralAddMatChannel LOCsceneMats[LOCmatName] LOCnewMap false
            )
          )

          DYNFUNnodeCreatedCallback()
          if LOCaddCnt > 0 then DYNFUNupdateMatPanel LOCaddCnt
        )
      )
    )
  )

  on BUDYNMaterialEditor pressed do
  (
    if sceneMaterials[LOCmatName] != undefined then
    (
      local LOCdefSlot = DYNamite.dnExplorer.selectedNode.tag as integer ; if classOf LOCdefSlot != integer then LOCdefSlot = 1
      medit.PutMtlToMtlEditor sceneMaterials[(substring DYNamite.dnExplorer.selectedNode.name 2 -1)] LOCdefSlot
      ActiveMeditSlot = LOCdefSlot
      max mtledit
    )
  )

  on CKDYNvehBody changed arg do
  (
    local LOCsceneMats = sceneMaterials
    rootNode.DYNrootNodeStore.vehRayTrace = arg
    if LOCsceneMats[DYNmatNameVehicles] != undefined then
    (
      if rootNode.DYNrootNodeStore.vehRayTrace then SPDYNvehBody.enabled = true else SPDYNvehBody.enabled = false
      for i = 1 to 9 do
      (
        try (LOCsceneMats[DYNmatNameVehicles][i].reflectionMapEnable = rootNode.DYNrootNodeStore.vehRayTrace) catch ()
      )
    )
  )

  on MLDYNchanList selected arg do
  (
    local LOCsceneMats = sceneMaterials
    BMDYNdiffMap.bitmap = DYNFUNrenderMatMap (DYNiniExplorerWidth - 21) LOCmapSize.y LOCsceneMats[LOCmatName] arg
  )

  on BUDYNresetMaterial pressed do
  (
    DYNFUNresetMaterial LOCmatName
  )
)

